//=============================================================================
// Gold.
//=============================================================================
class Realms_Item_Gold extends HealthVial;

#exec TEXTURE IMPORT NAME=GoldCoin  FILE=Textures\GoldCoin.bmp MIPS=ON

#exec mesh import mesh=Gold anivfile=Models\Gold_a.3d datafile=Models\Gold_d.3d x=0 y=0 z=0 mlod=0
#exec mesh origin mesh=Gold x=0 y=0 z=0
#exec mesh sequence mesh=Gold seq=All startframe=0 numframes=1

#exec meshmap new meshmap=Gold mesh=Gold
#exec meshmap scale meshmap=Gold x=0.02813 y=0.02813 z=0.05625

var() int HealingAmount;
var() bool bSuperHeal;

event float BotDesireability(Pawn Bot)
{
	local float desire;
	local int HealMax;

	HealMax = Bot.Default.Health;
	if (bSuperHeal) HealMax = Min(199, HealMax * 2.0);
	desire = Min(HealingAmount, HealMax - Bot.Health);

	if ( (Bot.Weapon != None) && (Bot.Weapon.AIRating > 0.5) )
		desire *= 1.7;
	if ( Bot.Health < 45 )
		return ( FMin(0.03 * desire, 2.2) );
	else
	{
		if ( desire > 6 )
			desire = FMax(desire,25);
		return ( FMin(0.017 * desire, 2.0) ); 
	}
}

function PlayPickupMessage(Pawn Other)
{
	Other.ReceiveLocalizedMessage( class'PickupMessageHealthPlus', 0, None, None, Self.Class );
}

auto state Pickup
{	
	function Touch( actor Other )
	{
		local int HealMax;
		local Pawn P;
		local Realms_Models_MaleKnight KnightP;
		
		if ( ValidTouch(Other) ) 
			{
			P = Pawn(Other);	
			if ( P.IsA('Realms_Models_MaleKnight'))
				{
				KnightP.Gold += 5;
				log("KnightP's gold amount is now: "@KnightP.Gold);
				}
			PlayPickupMessage(P);
			PlaySound (PickupSound,,2.5);
			Other.MakeNoise(0.2);		
			SetRespawn();	
			}
	
/*		if ( ValidTouch(Other) ) 
		{	
			P = Pawn(Other);	
			HealMax = P.default.health;
			if (bSuperHeal) HealMax = Min(199, HealMax * 2.0);
			if (P.Health < HealMax) 
			{
				if (Level.Game.LocalLog != None)
					Level.Game.LocalLog.LogPickup(Self, P);
				if (Level.Game.WorldLog != None)
					Level.Game.WorldLog.LogPickup(Self, P);
				P.Health += HealingAmount;
				if (P.Health > HealMax) P.Health = HealMax;
				PlayPickupMessage(P);
				PlaySound (PickupSound,,2.5);
				Other.MakeNoise(0.2);		
				SetRespawn();
			}
		}
*/
	}
}


/*
auto state Pickup
{	
function Touch( actor Other )
	{
	local Realms_Models_MaleKnight KnightP;
	local Pawn P;
		
	if ( ValidTouch(Other) ) 
		{	
		if ( Other.IsA('Realms_Models_MaleKnight'))	
			KnightP.Gold += 5;
		PlayPickupMessage(P);
		PlaySound (PickupSound,,2.5);
		Other.MakeNoise(0.2);		
		SetRespawn();	
		}
	}
}

function PlayPickupMessage(Pawn Other)
{
	Other.ReceiveLocalizedMessage( class'PickupMessageHealthPlus', 0, None, None, Self.Class );
}

*/
defaultproperties
{
     HealingAmount=5
     bSuperHeal=True
     PickupMessage="Your gold amount has been increased by "
     ItemName="Gold"
     RespawnTime=999999999.000000
     PickupViewMesh=Mesh'Gold'
     //PickupSound=Sound'AmbAncient.OneShot.bhit1'
     Mesh=Mesh'Gold'
     ScaleGlow=2.000000
     CollisionRadius=16.000000
     CollisionHeight=8
     bCollideWhenPlacing=True
     MultiSkins(0)=Texture'GoldCoin'

}
